
#import <Foundation/Foundation.h>
#ifndef MAC_OS_X_VERSION_10_5
#import <InterfaceBuilder/InterfaceBuilder.h>		// <IBConnectors> protocol
#endif


@interface MCBinderConnection:NSObject 			// <IBConnectors>
{
    NSString	*attributeName;
    
    id		source;
    id		destination;
	
    int		accessMode;
    BOOL	mandatoryFlag;
    BOOL	tagFlag;
}

// FACTORY METHODS

+ (void)initialize;

// INSTANCE METHODS

- initFrom:aSource to:aDestination;
- (void)dealloc;

// ACCESSORS 

- (NSString *)attributeName;
- (void)setAttributeName:(NSString *)name;

- (int)accessMode;
- (void)setAccessMode:(int)aValue;
- (NSString *)accessMode_UI;

- (BOOL)mandatoryFlag;
- (void)setMandatoryFlag:(BOOL)aValue;

- (BOOL)tagFlag;
- (void)setTagFlag:(BOOL)aValue;

- source;
- destination;
- (void)setSource:aSource;
- (void)setDestination:aDestination;

- (id)nibInstantiate;
- (void)establishConnection;


// TYPED STREAM SUPPORT 

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end
